/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blocks;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.armor.BacktankBlock;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.blockentitites.RefinedRadianceBacktankBE;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.armors.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.registries.QOLBlockEntities;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.BlockHitResult;

public class RefinedRadianceBacktankBlock
extends BacktankBlock {
    public RefinedRadianceBacktankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> ((RefinedRadianceBacktankBE)((Object)be)).setElytra(ShadowRadianceChestplate.hasElytra(stack)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        RefinedRadianceBacktankBE be;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof RefinedRadianceBacktankBE && !(be = (RefinedRadianceBacktankBE)blockEntity).hasElytra() && player.getMainHandItem().is(Items.ELYTRA)) {
            if (!((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get()).booleanValue()) {
                player.displayClientMessage((Component)CreateQOLLang.translateDirect("backtank.elytra_disabled", new Object[0]).withStyle(ChatFormatting.RED), true);
                level.playSound(null, pos, AllSoundEvents.DENY.getMainEvent(), SoundSource.PLAYERS, 1.0f, 1.45f);
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            be.setElytra(true);
            if (be.hasElytra()) {
                ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
                if (enchantments != null && !enchantments.isEmpty()) {
                    ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                    book.set(DataComponents.STORED_ENCHANTMENTS, (Object)enchantments);
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)book);
                }
                player.getMainHandItem().shrink(1);
                level.playSound(null, pos, SoundEvents.COPPER_BREAK, SoundSource.PLAYERS, 1.0f, 1.45f);
            }
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(pLevel, pos, state);
        Item item = this.asItem();
        if (item instanceof BacktankItem.BacktankBlockItem) {
            BacktankItem.BacktankBlockItem placeable = (BacktankItem.BacktankBlockItem)item;
            item = placeable.getActualItem();
        }
        Optional blockEntityOptional = this.getBlockEntityOptional((BlockGetter)pLevel, pos);
        blockEntityOptional.ifPresent(obe -> {
            RefinedRadianceBacktankBE be = (RefinedRadianceBacktankBE)((Object)obe);
            boolean elytra = be.hasElytra();
            stack.set(QOLDataComponents.BACKTANK_ELYTRA, (Object)elytra);
        });
        return stack;
    }

    public Class<BacktankBlockEntity> getBlockEntityClass() {
        return super.getBlockEntityClass();
    }

    public BlockEntityType<? extends BacktankBlockEntity> getBlockEntityType() {
        return (BlockEntityType)QOLBlockEntities.REFINED_RADIANCE_CHEST_BE.get();
    }
}

