/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites.visuals;

import com.simibubi.create.AllPartialModels;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.registries.QOLPartialModels;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class StockManagerVisual
extends AbstractBlockEntityVisual<StockManagerBlockEntity>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    private final TransformedInstance head;
    @Nullable
    private TransformedInstance smallRods;
    @Nullable
    private TransformedInstance largeRods;
    @Nullable
    private TransformedInstance hat;

    public StockManagerVisual(VisualizationContext ctx, StockManagerBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        PartialModel blazeModel = AllPartialModels.BLAZE_IDLE;
        this.head = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)blazeModel)).createInstance();
        this.head.light(0xF000F0);
        PartialModel rodsModel = QOLPartialModels.STOCK_MANAGER_RODS_1;
        PartialModel rodsModel2 = QOLPartialModels.STOCK_MANAGER_RODS_2;
        this.smallRods = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)rodsModel)).createInstance();
        this.largeRods = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)rodsModel2)).createInstance();
        this.smallRods.light(0xF000F0);
        this.largeRods.light(0xF000F0);
        this.hat = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.LOGISTICS_HAT)).createInstance();
        this.hat.light(0xF000F0);
        this.animate(partialTick);
    }

    public void tick(TickableVisual.Context context) {
        ((StockManagerBlockEntity)this.blockEntity).tickAnimation();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        if (!this.isVisible(ctx.frustum()) || this.doDistanceLimitThisFrame(ctx)) {
            return;
        }
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTicks) {
        float animation = ((StockManagerBlockEntity)this.blockEntity).headAnimation.getValue(partialTicks) * 0.175f;
        int hashCode = ((Object)((Object)((StockManagerBlockEntity)this.blockEntity))).hashCode();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)this.level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = 64.0f;
        float offset = Mth.sin((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float headY = offset - animation * 0.75f;
        float horizontalAngle = AngleHelper.rad((double)((StockManagerBlockEntity)this.blockEntity).headAngle.getValue(partialTicks));
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.head.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(0.025f)).translateY(headY)).translate(0.5f)).rotateY(horizontalAngle).translateBack(0.5f)).setChanged();
        if (this.hat != null) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.hat.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(0.025f)).translateY(headY)).translateY(0.75f);
            ((TransformedInstance)this.hat.rotateCentered(horizontalAngle + (float)Math.PI, Direction.UP)).translate(0.5f, 0.0f, 0.5f).light(0xF000F0);
            this.hat.setChanged();
        }
        if (this.smallRods != null) {
            float offset1 = Mth.sin((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.smallRods.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(0.025f)).translateY(offset1 + animation + 0.125f)).setChanged();
        }
        if (this.largeRods != null) {
            float offset2 = Mth.sin((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.largeRods.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(0.025f)).translateY(offset2 + animation - 0.1875f)).setChanged();
        }
    }

    public void updateLight(float partialTick) {
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    protected void _delete() {
        this.head.delete();
        if (this.smallRods != null) {
            this.smallRods.delete();
        }
        if (this.largeRods != null) {
            this.largeRods.delete();
        }
        if (this.hat != null) {
            this.hat.delete();
        }
    }
}

