/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import glitchcore.event.TickEvent;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.Season;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonTime;

public class SeasonHandlerClient {
    static Season.SubSeason lastSeason = null;
    public static final HashMap<ResourceKey<Level>, Integer> clientSeasonCycleTicks = new HashMap();

    public static void onClientTick(TickEvent.Client event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ResourceKey dimension = player.level().dimension();
        if (event.getPhase() == TickEvent.Phase.END && ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)dimension)) {
            clientSeasonCycleTicks.compute((ResourceKey<Level>)dimension, (k, v) -> v == null ? 0 : (v + 1) % SeasonTime.ZERO.getCycleDuration());
            SeasonTime calendar = new SeasonTime(clientSeasonCycleTicks.get(dimension));
            if (calendar.getSubSeason() != lastSeason) {
                Minecraft.getInstance().levelRenderer.allChanged();
                lastSeason = calendar.getSubSeason();
            }
        }
    }
}

