/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.generation.recipes.AbstractType;
import fr.samlegamer.addonslib.generation.recipes.mat.McwStoneMat;
import fr.samlegamer.addonslib.generation.recipes.mat.McwWoodMat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

class Trapdoors
extends AbstractType {
    private static final String id = "mcwtrpdoors";

    public Trapdoors(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries, String modid, String originalMod) {
        super(pOutput, pRegistries, modid, originalMod, id);
    }

    private void trapdoor_variant(RecipeOutput consumer, Block door_var, Block planks, Item print) {
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"A", "B", "A"}, (ItemLike)door_var, 1, (ItemLike)planks, (ItemLike)print, Objects.requireNonNull(print.toString()).replace("print_", "") + "_trapdoors");
    }

    private void other_traps(RecipeOutput consumer, String mat, Block log, Block planks, Block slab) {
        Block bark_trapdoor = Finder.findBlock(this.modid, mat + "_bark_trapdoor");
        Block glass_trapdoor = Finder.findBlock(this.modid, mat + "_glass_trapdoor");
        Block barn_trapdoor = Finder.findBlock(this.modid, mat + "_barn_trapdoor");
        Block ranch_trapdoor = Finder.findBlock(this.modid, mat + "_ranch_trapdoor");
        Block barrel_trapdoor = Finder.findBlock(this.modid, mat + "_barrel_trapdoor");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)log, new String[]{"ABA", "BBB", "ABA"}, (ItemLike)ranch_trapdoor, 2, (ItemLike)log, (ItemLike)Items.STICK, "ranch_trapdoors");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)log, new String[]{"ABA", "ABA"}, (ItemLike)bark_trapdoor, 2, (ItemLike)log, (ItemLike)Blocks.GLASS_PANE, "bark_trapdoors");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"ABA", "ABA"}, (ItemLike)glass_trapdoor, 2, (ItemLike)planks, (ItemLike)Blocks.GLASS_PANE, "glass_trapdoors");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"A", "B"}, (ItemLike)barn_trapdoor, 1, (ItemLike)planks, (ItemLike)glass_trapdoor, "barn_trapdoors");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{" A ", "ABA", " A "}, (ItemLike)barrel_trapdoor, 4, (ItemLike)planks, (ItemLike)Blocks.BARREL, "barrel_trapdoors");
    }

    @Override
    public void buildWood(RecipeOutput consumer, List<String> MAT, List<McwWoodMat> woodMat) {
        String[] variants = new String[]{"bamboo", "barred", "beach", "blossom", "classic", "cottage", "four_panel", "mystic", "paper", "swamp", "tropical", "whispering"};
        if (MAT.size() == woodMat.size()) {
            for (int i = 0; i < MAT.size(); ++i) {
                Block log = woodMat.get(i).getLog();
                Block planks = woodMat.get(i).getPlanks();
                Block slab = woodMat.get(i).getSlab();
                this.other_traps(consumer, MAT.get(i), log, planks, slab);
                for (String variant : variants) {
                    Item print = Finder.findItem(id, "print_" + variant);
                    Block door_var = Finder.findBlock(this.modid, MAT.get(i) + "_" + variant + "_trapdoor");
                    this.trapdoor_variant(consumer, door_var, planks, print);
                }
            }
        }
    }

    @Override
    public void buildStone(RecipeOutput consumer, List<String> MAT, List<McwStoneMat> stone) {
    }

    @Override
    public void buildHedge(RecipeOutput consumer, List<String> MAT, List<Block> leave) {
    }
}

