/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.util;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class QueueInventory
implements IItemHandler {
    private NonNullList<ItemStack> content = NonNullList.create();

    public int getSlots() {
        return this.content.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.content.get(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack c = (ItemStack)this.content.get(slot);
        if (c.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int a = Math.min(c.getCount(), amount);
        if (simulate) {
            c = c.copy();
            c.setCount(a);
            return c;
        }
        return c.split(a);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return false;
    }

    public void add(ItemStack is) {
        this.content.add((Object)is);
    }

    public ListTag toTag(HolderLookup.Provider registries) {
        ListTag tag = new ListTag();
        this.content.stream().filter(s -> !s.isEmpty()).map(s -> s.save(registries)).forEach(arg_0 -> tag.add(arg_0));
        return tag;
    }

    public void load(ListTag tag, HolderLookup.Provider registries) {
        this.content.clear();
        for (int i = 0; i < tag.size(); ++i) {
            this.content.add((Object)ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(i)));
        }
    }

    public <T> T asCap() {
        return (T)this;
    }

    public boolean hasSpace() {
        this.content.removeIf(ItemStack::isEmpty);
        return this.content.size() < 16;
    }
}

