/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.harvest;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.ShearsToolHandler;
import snownee.jade.util.CommonProxy;

public class LootTableMineableCollector {
    private final Registry<LootTable> lootRegistry;
    private final ItemStack toolItem;

    public LootTableMineableCollector(Registry<LootTable> lootRegistry, ItemStack toolItem) {
        this.lootRegistry = lootRegistry;
        this.toolItem = toolItem;
    }

    public static List<Block> execute(Registry<LootTable> lootRegistry, ItemStack toolItem) {
        Stopwatch stopwatch = null;
        if (CommonProxy.isDevEnv()) {
            stopwatch = Stopwatch.createStarted();
        }
        LootTableMineableCollector collector = new LootTableMineableCollector(lootRegistry, toolItem);
        ArrayList list = Lists.newArrayList();
        for (Block block : BuiltInRegistries.BLOCK) {
            LootTable lootTable;
            if (!ShearsToolHandler.getInstance().test(block.defaultBlockState()).isEmpty() || !collector.doLootTable(lootTable = (LootTable)lootRegistry.get(block.getLootTable()))) continue;
            list.add(block);
        }
        if (stopwatch != null) {
            Jade.LOGGER.info("LootTableMineableCollector took {}", (Object)stopwatch.stop());
        }
        return list;
    }

    private boolean doLootTable(LootTable lootTable) {
        if (lootTable == null || lootTable == LootTable.EMPTY) {
            return false;
        }
        for (LootPool pool : lootTable.pools) {
            if (!this.doLootPool(pool)) continue;
            return true;
        }
        return false;
    }

    private boolean doLootPool(LootPool lootPool) {
        for (LootPoolEntryContainer entry : lootPool.entries) {
            if (!this.doLootPoolEntry(entry)) continue;
            return true;
        }
        return false;
    }

    private boolean doLootPoolEntry(LootPoolEntryContainer entry) {
        if (entry instanceof AlternativesEntry) {
            AlternativesEntry alternativesEntry = (AlternativesEntry)entry;
            for (LootPoolEntryContainer child : alternativesEntry.children) {
                if (!this.doLootPoolEntry(child)) continue;
                return true;
            }
        } else {
            if (entry instanceof NestedLootTable) {
                NestedLootTable nestedLootTable = (NestedLootTable)entry;
                LootTable lootTable = (LootTable)nestedLootTable.contents.map(arg_0 -> this.lootRegistry.get(arg_0), Function.identity());
                return this.doLootTable(lootTable);
            }
            return CommonProxy.isCorrectConditions(entry.conditions, this.toolItem);
        }
        return false;
    }
}

