/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry;

import com.mojang.blaze3d.systems.RenderSystem;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public enum NumismaticsGuiTextures implements ScreenElement
{
    ANDESITE_DEPOSITOR("andesite_depositor", 182, 79),
    BRASS_DEPOSITOR("brass_depositor", 208, 145),
    BANK_TERMINAL("bank_terminal", 200, 132),
    TRUST_LIST("trust_list", 200, 110),
    BLAZE_BANKER("blaze_banker", 200, 110),
    VENDOR("vendor", 236, 145),
    CREATIVE_VENDOR("creative_vendor", 236, 145);

    public static final int FONT_COLOR = 5726074;
    public final ResourceLocation location;
    public int width;
    public int height;
    public int startX;
    public int startY;

    private NumismaticsGuiTextures(String location, int width, int height) {
        this(location, 0, 0, width, height);
    }

    private NumismaticsGuiTextures(int startX, int startY) {
        this("icons", startX * 16, startY * 16, 16, 16);
    }

    private NumismaticsGuiTextures(String location, int startX, int startY, int width, int height) {
        this("numismatics", location, startX, startY, width, height);
    }

    private NumismaticsGuiTextures(String namespace, String location, int startX, int startY, int width, int height) {
        this.location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("textures/gui/" + location + ".png"));
        this.width = width;
        this.height = height;
        this.startX = startX;
        this.startY = startY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        this.bind();
        graphics.blit(this.location, x, y, 0, (float)this.startX, (float)this.startY, this.width, this.height, 256, 256);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y, Color c) {
        this.bind();
        UIRenderHelper.drawColoredTexture((GuiGraphics)graphics, (Color)c, (int)x, (int)y, (int)this.startX, (int)this.startY, (int)this.width, (int)this.height);
    }
}

