/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.neoforge.NumismaticsDataNeoForge;
import dev.ithundxr.createnumismatics.registry.NumismaticsAdvancements;
import dev.ithundxr.createnumismatics.registry.NumismaticsTriggers;
import dev.ithundxr.createnumismatics.registry.commands.arguments.EnumArgument;
import dev.ithundxr.createnumismatics.registry.neoforge.NumismaticsCreativeModeTabsImpl;
import dev.ithundxr.createnumismatics.registry.neoforge.NumismaticsDataComponentsImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="numismatics")
@EventBusSubscriber
public class NumismaticsImpl {
    static IEventBus modEventBus;
    private static final Set<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>> commandConsumers;

    public NumismaticsImpl(IEventBus modEventBus) {
        NumismaticsImpl.modEventBus = modEventBus;
        NumismaticsCreativeModeTabsImpl.register(modEventBus);
        NumismaticsDataComponentsImpl.register(modEventBus);
        Numismatics.init();
        modEventBus.addListener(NumismaticsImpl::registerArgumentTypes);
        modEventBus.addListener(NumismaticsImpl::onRegisterEvent);
        modEventBus.addListener(EventPriority.HIGHEST, NumismaticsDataNeoForge::gatherDataHighPriority);
        modEventBus.addListener(EventPriority.LOWEST, NumismaticsDataNeoForge::gatherData);
    }

    private static void registerArgumentTypes(RegisterEvent event) {
        event.register(Registries.COMMAND_ARGUMENT_TYPE, Numismatics.asResource("enum"), () -> ArgumentTypeInfos.registerByClass(EnumArgument.class, new EnumArgument.Info()));
    }

    public static void onRegisterEvent(RegisterEvent event) {
        if (event.getRegistry() == BuiltInRegistries.TRIGGER_TYPES) {
            NumismaticsAdvancements.register();
            NumismaticsTriggers.register();
        }
    }

    public static String findVersion() {
        String versionString = "UNKNOWN";
        List infoList = ModList.get().getModFileById("numismatics").getMods();
        if (infoList.size() > 1) {
            Numismatics.LOGGER.error("Multiple mods for MOD_ID: numismatics");
        }
        for (IModInfo info : infoList) {
            if (!info.getModId().equals("numismatics")) continue;
            versionString = MavenVersionTranslator.artifactVersionToString((ArtifactVersion)info.getVersion());
            break;
        }
        return versionString;
    }

    public static void finalizeRegistrate() {
        Numismatics.registrate().registerEventListeners(modEventBus);
    }

    public static void registerCommands(BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean> consumer) {
        commandConsumers.add(consumer);
    }

    @SubscribeEvent
    public static void onCommandRegistration(RegisterCommandsEvent event) {
        Commands.CommandSelection selection = event.getCommandSelection();
        boolean dedicated = selection == Commands.CommandSelection.ALL || selection == Commands.CommandSelection.DEDICATED;
        commandConsumers.forEach(consumer -> consumer.accept(event.getDispatcher(), dedicated));
    }

    static {
        commandConsumers = new HashSet<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>>();
    }
}

