/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinDisplaySlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.SlotDiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.depositor.BrassDepositorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BrassDepositorMenu
extends MenuBase<BrassDepositorBlockEntity> {
    public static final int COIN_SLOTS;
    public static final int CARD_SLOT_INDEX;
    public static final int PLAYER_INV_START_INDEX;
    public static final int PLAYER_HOTBAR_END_INDEX;
    public static final int PLAYER_INV_END_INDEX;

    public BrassDepositorMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public BrassDepositorMenu(MenuType<?> type, int id, Inventory inv, BrassDepositorBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    protected BrassDepositorBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof BrassDepositorBlockEntity) {
            BrassDepositorBlockEntity brassDepositorBE = (BrassDepositorBlockEntity)blockEntity;
            brassDepositorBE.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return brassDepositorBE;
        }
        return null;
    }

    protected void initAndReadInventory(BrassDepositorBlockEntity contentHolder) {
    }

    protected void addSlots() {
        int x = 37;
        int y = 122;
        for (Coin coin : Coin.values()) {
            this.addSlot(new SlotDiscreteCoinBag(((BrassDepositorBlockEntity)this.contentHolder).inventory, coin, x += 18, y, true, true));
        }
        this.addSlot(new CardSlot.BoundCardSlot(((BrassDepositorBlockEntity)this.contentHolder).cardContainer, 0, 37, y));
        this.addPlayerSlots(44, 165);
        int labelX1 = 25;
        int labelX2 = labelX1 + 86;
        int labelY = 46;
        int labelYIncrement = 22;
        for (int i = 0; i < 6; ++i) {
            Coin coin = Coin.values()[i];
            int slotX = i < 3 ? labelX1 : labelX2;
            int slotY = labelY + i % 3 * labelYIncrement;
            this.addSlot(new CoinDisplaySlot(coin, slotX, slotY));
        }
    }

    protected void saveData(BrassDepositorBlockEntity contentHolder) {
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        super.clicked(slotId, button, clickType, player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot clickedSlot = this.getSlot(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = clickedSlot.getItem();
        if (index < COIN_SLOTS) {
            Item item = stack.getItem();
            if (!(item instanceof CoinItem)) {
                return ItemStack.EMPTY;
            }
            CoinItem coinItem = (CoinItem)item;
            Coin coin = coinItem.coin;
            int startCount = stack.getCount();
            this.moveItemStackTo(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false);
            int diff = startCount - stack.getCount();
            if (diff > 0) {
                ((BrassDepositorBlockEntity)this.contentHolder).inventory.subtract(coin, diff);
                clickedSlot.setChanged();
            } else if (diff < 0) {
                ((BrassDepositorBlockEntity)this.contentHolder).inventory.add(coin, -diff);
                clickedSlot.setChanged();
            }
            return ItemStack.EMPTY;
        }
        if (index == CARD_SLOT_INDEX) {
            if (!this.moveItemStackTo(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            if (stack.getItem() instanceof CoinItem && !this.moveItemStackTo(stack, 0, COIN_SLOTS, false)) {
                return ItemStack.EMPTY;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(stack) && !this.moveItemStackTo(stack, CARD_SLOT_INDEX, CARD_SLOT_INDEX + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= PLAYER_INV_START_INDEX && index < PLAYER_HOTBAR_END_INDEX && !this.moveItemStackTo(stack, PLAYER_HOTBAR_END_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= PLAYER_HOTBAR_END_INDEX && index < PLAYER_INV_END_INDEX && !this.moveItemStackTo(stack, PLAYER_INV_START_INDEX, PLAYER_HOTBAR_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    static {
        CARD_SLOT_INDEX = COIN_SLOTS = Coin.values().length;
        PLAYER_INV_START_INDEX = CARD_SLOT_INDEX + 1;
        PLAYER_HOTBAR_END_INDEX = PLAYER_INV_START_INDEX + 9;
        PLAYER_INV_END_INDEX = PLAYER_INV_START_INDEX + 36;
    }
}

