/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.AllSoundEvents;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlock;
import dev.ithundxr.createnumismatics.content.depositor.AndesiteDepositorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlockEntities;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class AndesiteDepositorBlock
extends AbstractDepositorBlock<AndesiteDepositorBlockEntity> {
    public AndesiteDepositorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<AndesiteDepositorBlockEntity> getBlockEntityClass() {
        return AndesiteDepositorBlockEntity.class;
    }

    public BlockEntityType<AndesiteDepositorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NumismaticsBlockEntities.ANDESITE_DEPOSITOR.get();
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hitResult.getDirection().getAxis().isVertical()) {
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (this.isTrusted(player, (BlockGetter)level, pos)) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> Utils.openScreen((ServerPlayer)player, be, arg_0 -> ((AndesiteDepositorBlockEntity)be).sendToMenu(arg_0)));
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (state.getValue((Property)HORIZONTAL_FACING) != hitResult.getDirection()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() || ((Boolean)state.getValue((Property)LOCKED)).booleanValue()) {
            return ItemInteractionResult.FAIL;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AndesiteDepositorBlockEntity) {
            AndesiteDepositorBlockEntity andesiteDepositor = (AndesiteDepositorBlockEntity)blockEntity;
            Coin coin = andesiteDepositor.getCoin();
            if (NumismaticsTags.AllItemTags.CARDS.matches(stack)) {
                UUID id;
                BankAccount account;
                if (CardItem.isBound(stack) && (account = Numismatics.BANK.getAccount(id = CardItem.get(stack))) != null && account.isAuthorized(player) && account.deduct(coin, 1)) {
                    this.activate(state, level, pos);
                    andesiteDepositor.addCoin(coin, 1);
                }
            } else if (CoinItem.extract(player, hand, coin, true)) {
                this.activate(state, level, pos);
                andesiteDepositor.addCoin(coin, 1);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.insufficient_funds").withStyle(ChatFormatting.DARK_RED), true);
                level.playSound(null, pos, AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        return ItemInteractionResult.CONSUME;
    }
}

