/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.mojang.datafixers.util.Pair;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.MergingCoinBag;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotInputMergingCoinBag
extends Slot {
    private static final Container emptyInventory = new SimpleContainer(0);
    private final MergingCoinBag coinBag;
    @Nullable
    private final Coin coin;

    public SlotInputMergingCoinBag(MergingCoinBag coinBag, @Nullable Coin coin, int x, int y) {
        super(emptyInventory, 0, x, y);
        this.coinBag = coinBag;
        this.coin = coin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayPlace(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (!(item instanceof CoinItem)) return false;
        CoinItem coinItem = (CoinItem)item;
        if (this.coin == null) return true;
        if (coinItem.coin != this.coin) return false;
        return true;
    }

    @NotNull
    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    public void set(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof CoinItem) {
            CoinItem coinItem = (CoinItem)item;
            if (this.coin == null || coinItem.coin == this.coin) {
                this.coinBag.add(coinItem.coin, stack.getCount());
                stack.setCount(0);
                this.setChanged();
            }
        }
    }

    public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return this.getMaxStackSize();
    }

    public boolean mayPickup(@NotNull Player player) {
        return false;
    }

    @NotNull
    public ItemStack remove(int amount) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public Optional<ItemStack> tryRemove(int count, int decrement, @NotNull Player player) {
        return Optional.empty();
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)Numismatics.asResource((String)(this.coin == null ? "item/coin/outline/animated" : "item/coin/outline/" + this.coin.getName())));
    }
}

