/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import dev.ithundxr.createnumismatics.base.client.rendering.GuiBlockEntityRenderBuilder;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerBlockEntity;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerEditPacket;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsGuiTextures;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BlazeBankerScreen
extends AbstractSimiContainerScreen<BlazeBankerMenu> {
    private EditBox labelBox;
    private IconButton confirmButton;
    private final NumismaticsGuiTextures background = NumismaticsGuiTextures.BLAZE_BANKER;
    private final ItemStack renderedItem = NumismaticsBlocks.BLAZE_BANKER.asStack();
    private List<Rect2i> extraAreas = Collections.emptyList();

    public BlazeBankerScreen(BlazeBankerMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void init() {
        this.setWindowSize(this.background.width, this.background.height + 2 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-20, 0);
        super.init();
        int x = this.leftPos;
        int y = this.topPos;
        Consumer<String> onTextChanged = s -> this.labelBox.setX(this.nameBoxX((String)s, this.labelBox));
        this.labelBox = new EditBox((Font)new NoShadowFontWrapper(this.font), x + 23, y + 4, this.background.width - 20, 10, (Component)Component.literal((String)((BlazeBankerBlockEntity)((BlazeBankerMenu)this.menu).contentHolder).getLabelNonNull()));
        this.labelBox.setBordered(false);
        this.labelBox.setMaxLength(25);
        this.labelBox.setTextColor(5841956);
        this.labelBox.setValue(((BlazeBankerBlockEntity)((BlazeBankerMenu)this.menu).contentHolder).getLabelNonNull());
        this.labelBox.setFocused(false);
        this.labelBox.mouseClicked(0.0, 0.0, 0);
        this.labelBox.setResponder(onTextChanged);
        this.labelBox.setX(this.nameBoxX(this.labelBox.getValue(), this.labelBox));
        this.addRenderableWidget((GuiEventListener)this.labelBox);
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> ((BlazeBankerScreen)this).onClose());
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width, y + this.background.height - 64, 84, 74));
    }

    protected void containerTick() {
        super.containerTick();
        if (this.getFocused() != this.labelBox) {
            this.labelBox.setCursorPosition(this.labelBox.getValue().length());
            this.labelBox.setHighlightPos(this.labelBox.getCursorPosition());
        }
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    protected void renderForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        int x = this.leftPos;
        int y = this.topPos;
        String text = this.labelBox.getValue();
        if (!this.labelBox.isFocused()) {
            AllGuiTextures.STATION_EDIT_NAME.render(graphics, this.nameBoxX(text, this.labelBox) + this.font.width(text) + 5, y + 1);
        }
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.height + 2;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.leftPos;
        int y = this.topPos;
        this.background.render(graphics, x, y);
        Minecraft mc = Minecraft.getInstance();
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(x + this.background.width + 6), (float)(y + this.background.height - 70), -200.0f)).scale(5.0).render(graphics);
        ((GuiGameElement.GuiRenderBuilder)GuiBlockEntityRenderBuilder.of((BlazeBankerBlockEntity)((BlazeBankerMenu)this.menu).contentHolder).at(x + this.background.width + 6, y + this.background.height - 70, -230.0f)).scale(5.0).render(graphics);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!this.labelBox.isFocused() && pMouseY > (double)this.topPos && pMouseY < (double)(this.topPos + 14) && pMouseX > (double)this.leftPos && pMouseX < (double)(this.leftPos + this.background.width)) {
            this.labelBox.setFocused(true);
            this.labelBox.setHighlightPos(0);
            this.setFocused((GuiEventListener)this.labelBox);
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitEnter;
        boolean bl = hitEnter = this.getFocused() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.labelBox.isFocused()) {
            if (this.labelBox.getValue().isEmpty()) {
                this.labelBox.setValue("Blaze Banker");
            }
            this.labelBox.setFocused(false);
            this.syncName();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    private void syncName() {
        if (!this.labelBox.getValue().equals(((BlazeBankerBlockEntity)((BlazeBankerMenu)this.menu).contentHolder).getLabel())) {
            this.setLabel(this.labelBox.getValue());
        }
    }

    private void setLabel(String label) {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new BlazeBankerEditPacket(((BlazeBankerBlockEntity)((BlazeBankerMenu)this.menu).contentHolder).getBlockPos(), label));
    }

    public void removed() {
        super.removed();
        if (this.labelBox == null) {
            return;
        }
        this.syncName();
    }

    private int nameBoxX(String s, EditBox nameBox) {
        return this.leftPos + this.background.width / 2 - (Math.min(this.font.width(s), nameBox.getWidth()) + 10) / 2;
    }
}

