/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank;

import dev.ithundxr.createnumismatics.registry.NumismaticsDataComponents;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IDCardItem
extends Item {
    public final DyeColor color;

    public IDCardItem(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public static ItemStack clear(ItemStack itemStack) {
        itemStack.remove(NumismaticsDataComponents.ID_CARD_UUID);
        return itemStack;
    }

    public static ItemStack set(ItemStack itemStack, UUID id) {
        itemStack.set(NumismaticsDataComponents.ID_CARD_UUID, (Object)id);
        return itemStack;
    }

    @Nullable
    public static UUID get(ItemStack itemStack) {
        return (UUID)itemStack.get(NumismaticsDataComponents.ID_CARD_UUID);
    }

    @Nullable
    public static String getPlayerName(ItemStack itemStack) {
        if (!IDCardItem.isBound(itemStack)) {
            return null;
        }
        return UsernameUtils.INSTANCE.getName(IDCardItem.get(itemStack));
    }

    public static boolean isBound(ItemStack itemStack) {
        return itemStack.has(NumismaticsDataComponents.ID_CARD_UUID);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack handStack = player.getItemInHand(usedHand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)handStack);
        }
        if (IDCardItem.isBound(handStack)) {
            if (player.isShiftKeyDown()) {
                IDCardItem.clear(handStack);
                player.displayClientMessage((Component)Component.translatable((String)"item.numismatics.id_card.tooltip.cleared"), true);
                return InteractionResultHolder.success((Object)handStack);
            }
            player.displayClientMessage((Component)Component.translatable((String)"item.numismatics.id_card.tooltip.already_bound").withStyle(ChatFormatting.RED), true);
        } else if (!player.isShiftKeyDown()) {
            IDCardItem.set(handStack, player.getUUID());
            player.displayClientMessage((Component)Component.translatable((String)"item.numismatics.id_card.tooltip.bound"), true);
            return InteractionResultHolder.success((Object)handStack);
        }
        return InteractionResultHolder.pass((Object)handStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (IDCardItem.isBound(stack)) {
            tooltipComponents.add((Component)Component.translatable((String)"item.numismatics.card.tooltip.bound.to", (Object[])new Object[]{IDCardItem.getPlayerName(stack)}).withStyle(ChatFormatting.GREEN));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.numismatics.card.tooltip.blank"));
        }
    }
}

