/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend;

import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class BankSavedData
extends SavedData {
    private Map<UUID, BankAccount> accounts = new HashMap<UUID, BankAccount>();

    public static SavedData.Factory<BankSavedData> factory() {
        return new SavedData.Factory(BankSavedData::new, BankSavedData::load, null);
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        tag.put("Accounts", (Tag)NBTHelper.writeCompoundList(Numismatics.BANK.accounts.values(), t -> t.save(new CompoundTag())));
        return tag;
    }

    private static BankSavedData load(CompoundTag tag, HolderLookup.Provider registries) {
        BankSavedData sd = new BankSavedData();
        sd.accounts = new HashMap<UUID, BankAccount>();
        NBTHelper.iterateCompoundList((ListTag)tag.getList("Accounts", 10), c -> {
            BankAccount account = BankAccount.load(c);
            if (account != null) {
                sd.accounts.put(account.id, account);
            }
        });
        return sd;
    }

    private BankSavedData() {
    }

    public static BankSavedData load(MinecraftServer server) {
        return (BankSavedData)server.overworld().getDataStorage().computeIfAbsent(BankSavedData.factory(), "numismatics_bank");
    }

    public Map<UUID, BankAccount> getAccounts() {
        return this.accounts;
    }
}

