/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.jemi.JemiStack;
import dev.emi.emi.jemi.JemiUtil;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.util.GsonHelper;

public class JemiStackSerializer
implements EmiIngredientSerializer<JemiStack> {
    private final IIngredientManager manager;

    public JemiStackSerializer(IIngredientManager manager) {
        this.manager = manager;
    }

    @Override
    public String getType() {
        return "jemi";
    }

    public EmiStack create(String uid, long amount) {
        for (IIngredientType type : this.manager.getRegisteredIngredientTypes()) {
            Optional<EmiStack> opt;
            if (type == VanillaTypes.ITEM_STACK || type == JemiUtil.getFluidType() || !(opt = this.manager.getTypedIngredientByUid(type, uid).map(JemiUtil::getStack)).isPresent()) continue;
            return opt.get().setAmount(amount);
        }
        return EmiStack.EMPTY;
    }

    @Override
    public EmiIngredient deserialize(JsonElement element) {
        EmiIngredient ing;
        JsonObject json = element.getAsJsonObject();
        String uid = GsonHelper.getAsString((JsonObject)json, (String)"uid");
        long amount = GsonHelper.getAsLong((JsonObject)json, (String)"amount", (long)1L);
        float chance = GsonHelper.getAsFloat((JsonObject)json, (String)"chance", (float)1.0f);
        EmiStack remainder = EmiStack.EMPTY;
        if (GsonHelper.isValidNode((JsonObject)json, (String)"remainder") && (ing = EmiIngredientSerializer.getDeserialized(json.get("remainder"))) instanceof EmiStack) {
            EmiStack stack;
            remainder = stack = (EmiStack)ing;
        }
        EmiStack stack = this.create(uid, amount);
        if (chance != 1.0f) {
            stack.setChance(chance);
        }
        if (!remainder.isEmpty()) {
            stack.setRemainder(remainder);
        }
        return stack;
    }

    @Override
    public JsonElement serialize(JemiStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        json.addProperty("uid", stack.getJeiUid());
        if (stack.getAmount() != 1L) {
            json.addProperty("amount", (Number)stack.getAmount());
        }
        if (stack.getChance() != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(stack.getChance()));
        }
        if (!stack.getRemainder().isEmpty()) {
            JsonElement remainderElement;
            EmiStack remainder = stack.getRemainder();
            if (!remainder.getRemainder().isEmpty()) {
                remainder = remainder.copy().setRemainder(EmiStack.EMPTY);
            }
            if (remainder.getRemainder().isEmpty() && (remainderElement = EmiIngredientSerializer.getSerialized(remainder)) != null) {
                json.add("remainder", remainderElement);
            }
        }
        return json;
    }
}

