/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.runtime.EmiLog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public interface EmiStackSerializer<T extends EmiStack>
extends EmiIngredientSerializer<T> {
    public static final Pattern STACK_REGEX = Pattern.compile("^([\\w_\\-./]+):([\\w_\\-.]+):([\\w_\\-./]+)(\\{.*\\})?$");

    public EmiStack create(ResourceLocation var1, DataComponentPatch var2, long var3);

    private static <T> DynamicOps<T> withRegistryAccess(DynamicOps<T> ops) {
        Minecraft instance = Minecraft.getInstance();
        if (instance == null || instance.level == null) {
            return ops;
        }
        return instance.level.registryAccess().createSerializationContext(ops);
    }

    @Override
    default public EmiIngredient deserialize(JsonElement element) {
        ResourceLocation id = null;
        String nbt = null;
        long amount = 1L;
        float chance = 1.0f;
        EmiStack remainder = EmiStack.EMPTY;
        if (GsonHelper.isStringValue((JsonElement)element)) {
            String s = element.getAsString();
            Matcher m = STACK_REGEX.matcher(s);
            if (m.matches()) {
                id = EmiPort.id(m.group(2), m.group(3));
                nbt = m.group(4);
            }
        } else if (element.isJsonObject()) {
            EmiIngredient ing;
            JsonObject json = element.getAsJsonObject();
            id = EmiPort.id(GsonHelper.getAsString((JsonObject)json, (String)"id"));
            nbt = GsonHelper.getAsString((JsonObject)json, (String)"nbt", null);
            amount = GsonHelper.getAsLong((JsonObject)json, (String)"amount", (long)1L);
            chance = GsonHelper.getAsFloat((JsonObject)json, (String)"chance", (float)1.0f);
            if (GsonHelper.isValidNode((JsonObject)json, (String)"remainder") && (ing = EmiIngredientSerializer.getDeserialized(json.get("remainder"))) instanceof EmiStack) {
                EmiStack stack;
                remainder = stack = (EmiStack)ing;
            }
        }
        if (id != null) {
            try {
                DataComponentPatch changes = DataComponentPatch.EMPTY;
                if (nbt != null) {
                    changes = (DataComponentPatch)((Pair)DataComponentPatch.CODEC.decode(EmiStackSerializer.withRegistryAccess(NbtOps.INSTANCE), (Object)TagParser.parseTag(nbt)).getOrThrow()).getFirst();
                }
                EmiStack stack = this.create(id, changes, amount);
                if (chance != 1.0f) {
                    stack.setChance(chance);
                }
                if (!remainder.isEmpty()) {
                    stack.setRemainder(remainder);
                }
                return stack;
            }
            catch (Exception e) {
                EmiLog.error("Error parsing NBT in deserialized stack", e);
                return EmiStack.EMPTY;
            }
        }
        return EmiStack.EMPTY;
    }

    @Override
    default public JsonElement serialize(T stack) {
        String nbt = null;
        DataComponentPatch componentChanges = ((EmiStack)stack).getComponentChanges();
        if (componentChanges != DataComponentPatch.EMPTY) {
            nbt = ((Tag)DataComponentPatch.CODEC.encodeStart(EmiStackSerializer.withRegistryAccess(NbtOps.INSTANCE), (Object)componentChanges).getOrThrow()).getAsString();
        }
        if (((EmiStack)stack).getAmount() == 1L && ((EmiStack)stack).getChance() == 1.0f && ((EmiStack)stack).getRemainder().isEmpty()) {
            String s = this.getType() + ":" + String.valueOf(((EmiStack)stack).getId());
            if (nbt != null) {
                s = s + nbt;
            }
            return new JsonPrimitive(s);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        json.addProperty("id", ((EmiStack)stack).getId().toString());
        if (nbt != null) {
            json.addProperty("nbt", nbt);
        }
        if (((EmiStack)stack).getAmount() != 1L) {
            json.addProperty("amount", (Number)((EmiStack)stack).getAmount());
        }
        if (((EmiStack)stack).getChance() != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(((EmiStack)stack).getChance()));
        }
        if (!((EmiStack)stack).getRemainder().isEmpty()) {
            JsonElement remainderElement;
            EmiStack remainder = ((EmiStack)stack).getRemainder();
            if (!remainder.getRemainder().isEmpty()) {
                remainder = remainder.copy().setRemainder(EmiStack.EMPTY);
            }
            if (remainder.getRemainder().isEmpty() && (remainderElement = EmiIngredientSerializer.getSerialized(remainder)) != null) {
                json.add("remainder", remainderElement);
            }
        }
        return json;
    }
}

